/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  pint wakeup.c
*  :  XuQP
*  :  V1.0
*  :  2020/3/11
*  :  PINT
          1.ʵⲿжϻѣ400usT11˫PWMģʽʵPB1˿Ϊ100usռձ50% ķ
            ֮ٴμ˯ߣȴһж٣õʱҪǱ֤ʱʱPWM
            ֱӽ͹ģʽ
          עʱʱʱΪѭʱָʱNOPָĻڡ
*  ע:  ES7H202x
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include	<hic.h>
unsigned int Wake_Up;
void Delay25us(unsigned int time);
void RAMClear(void);

/*********************************************************
: void isr(void) interrupt
  : жϷ
ֵ: 
ֵ: 
ֵ:  
***********************************************************/ 
void isr(void) interrupt
{
	if ( PIE0 && PIF0 ) 
	{ 					    //PINT0ⲿж
	    PIF0 = 0;			//PINT0жϱ־
        Wake_Up = 1;        //ֵPWMжϱ־λ
	}
}

/*********************************************************
: void main()
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main(void)
{
    RAMClear();         //RAM
    
	PCS = 0x00;         //I/O˿
    PCT = 0xFF; 		//PC˿ȫΪ
	PCPD = 0xFF;		//ʹPC0˿ڵڲ
    
    PBS = 0x00;         //PB1ΪI/O   
    PB1 = 0;            //PB1˿͵ƽ
    PBT1= 0; 		    //PB1˿Ϊ      

    T11CL = 0xC1;		//T11˫PWMģʽ

	PIE0 = 1;	        //ʹPINT0ж
    PINTC = 0x00;	    //ⲿжش
	GIE = 1;			//ʹȫж
    
	while(1)
    {
        if(Wake_Up)
        {
            P11EN = 1;		       //PWM111ʹ
            T11CH = 0x80;		   //ʹT11
            
            T11PH = 1600 >> 8;
            T11PL = 1600;          //
            T11R1H = 800 >> 8;
            T11R1L = 800;          //þ
 
            Delay25us(2);          //ʱӺ
            Wake_Up = 0;           //㻽жϱ־λif˯
        }
        __Asm IDLE;
    }
}

/*********************************************************
:	void Delay25us(unsigned int time)
  :	ʱӳ, ѭʱ16MHz£ÿΪ0.125us
ֵ: timeʱλ25us
ֵ: 
ֵ:  
**********************************************************/
void Delay25us(unsigned int time)
{
	unsigned int i, j;

	for (i=0; i<time; i++)
	{
		for (j=0; j<100; j++)			
		{
			__Asm NOP;
 			__Asm NOP;
		}
	}
}

/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
	__asm{				    //ַ0x0000~0x05FF
		MOVI 0x00			
		MOVA IAAH 
		MOVI 0x00			
		MOVA IAAL 
		CLR	 IAD 
		INC	 IAAL,1
		JBS	 PSW,C
		GOTO $-3
		INC IAAH,1
		MOVI 0x06
		SUB  IAAH,0
		JBS	 PSW,C	
		GOTO $-8
	}
}	